<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

$data = json_decode(file_get_contents('php://input'), true);

if (!$data || !isset($data['surveyorID']) || !isset($data['accNo'])) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid input data"]);
    exit;
}

$surveyorID = $conn->real_escape_string($data['surveyorID']);
$accNos = $data['accNo'];

if (!is_array($accNos) || empty($accNos)) {
    http_response_code(400);
    echo json_encode(["error" => "accNo must be a non-empty array"]);
    exit;
}

$conn->begin_transaction();

try {
    $stmt = $conn->prepare("UPDATE customer_assignment SET surveyorID = ?, dateAssigned = NOW() WHERE accountNo = ?");
  
    foreach ($accNos as $accNo) {
        $cleanAccNo = $conn->real_escape_string($accNo);
        $stmt->bind_param("ss", $surveyorID, $cleanAccNo);
        $stmt->execute();
    }

    $stmt->close();
    $conn->commit();

    echo json_encode([
        "success" => true,
        "message" => count($accNos) . " customers assigned successfully"
    ]);

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>
