<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['empID']) || !isset($data['surveyorIDs'])) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'status' => 400,
        'message' => 'Supervisor ID and Surveyor IDs are required',
        'data' => null
    ]);
    exit();
}

$empID = $conn->real_escape_string($data['empID']);
$surveyorIDs = $data['surveyorIDs'];

if (!is_array($surveyorIDs) || empty($surveyorIDs)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'status' => 400,
        'message' => 'Surveyor IDs must be a non-empty array',
        'data' => null
    ]);
    exit();
}

$escapedIDs = array_map([$conn, 'real_escape_string'], $surveyorIDs);
$surveyorIDsString = "'" . implode("','", $escapedIDs) . "'";

$conn->begin_transaction();

try {
 
    $assignQuery = "UPDATE surveyor SET empID = '$empID' WHERE surveyorID IN ($surveyorIDsString)";
    if (!$conn->query($assignQuery)) {
        throw new Exception("Failed to assign surveyors: " . $conn->error);
    }

    $conn->commit();

    echo json_encode([
        'success' => true,
        'status' => 200,
        'message' => 'Surveyors assigned successfully',
        'data' => null
    ]);
} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'status' => 500,
        'message' => $e->getMessage(), 
        'data' => null
    ]);
}
exit;
?>
