<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

include 'connect.php';

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$role = isset($_GET['role']) ? $_GET['role'] : '';
$businessUnit = isset($_GET['businessUnit']) ? $_GET['businessUnit'] : '';
$filter = isset($_GET['filter']) ? $_GET['filter'] : ''; 
$approvalStatus = isset($_GET['approvalStatus']) ? $_GET['approvalStatus'] : ''; 

$sql = "";
$params = [];
$types = "";

switch ($role) {
    case "Admin":
        if ($filter === "approved") {
            $sql = "SELECT * FROM uploaded_survey_data WHERE verificationStatus = '1'";
        } elseif ($filter === "rejected") {
            $sql = "SELECT * FROM uploaded_survey_data WHERE verificationStatus = '2'";
        } else {
            $sql = "SELECT * FROM uploaded_survey_data";
        }
        break;

    case "MowasscoTeam":
        if (!empty($businessUnit)) {
            $sql = "SELECT * FROM uploaded_survey_data WHERE businessUnit = ? AND verificationStatus = '1'";
            $params[] = $businessUnit;
            $types .= "s";

            if ($approvalStatus !== '') {
                $sql .= " AND approvalStatus = ?";
                $params[] = $approvalStatus;
                $types .= "i";
            }
        }
        break;
        
    case "MowasscoSupervisor":  
        $sql = "SELECT * FROM uploaded_survey_data WHERE verificationStatus = '1'";
        
        if ($approvalStatus !== '') {
            $sql .= " AND approvalStatus = ?";
            $params[] = $approvalStatus;
            $types .= "i";
        }
        break;

    default:
        echo json_encode([]);
        $conn->close();
        exit;
}

$uploaded_survey_data = [];

if (!empty($sql)) {
    if (!empty($params)) {
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param($types, ...$params);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $uploaded_survey_data[] = $row;
                }
            }
            $stmt->close();
        }
    } else {
        $result = $conn->query($sql);
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $uploaded_survey_data[] = $row;
            }
        }
    }
}

$conn->close();

header('Content-Type: application/json');
echo json_encode($uploaded_survey_data);
?>