<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include 'connect.php';

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$role = isset($_GET['role']) ? $_GET['role'] : '';
$businessUnit = isset($_GET['businessUnit']) ? $_GET['businessUnit'] : '';

$response = ["count" => 0];

if ($role === "Admin") {
    $sql = "SELECT COUNT(*) as count FROM uploaded_survey_data";
    $result = $conn->query($sql);
    if ($result) {
        $response = $result->fetch_assoc();
    }
} elseif ($role === "MowasscoSupervisor") {
    $sql = "SELECT COUNT(*) as count 
            FROM uploaded_survey_data 
            WHERE verificationStatus = '1'";

    $stmt = $conn->prepare($sql);
    // $stmt->bind_param("s", $businessUnit);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result) {
        $response = $result->fetch_assoc();
    }
} elseif ($role === "MowasscoTeam" && !empty($businessUnit)) {
    $sql = "SELECT COUNT(*) as count 
            FROM uploaded_survey_data 
            WHERE businessUnit = ? AND verificationStatus = '1'";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $businessUnit);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result) {
        $response = $result->fetch_assoc();
    }
} else {
    $response = ["count" => 0];
}

$conn->close();

header('Content-Type: application/json');
echo json_encode($response);