<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include "connect.php";

$surveyorID = $_GET['surveyorID'] ?? null;

if (!$surveyorID) {
    http_response_code(400);
    echo json_encode(["error" => "surveyorID parameter is required"]);
    exit;
}

try {
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM customer_assignment WHERE surveyorID = ?");
    $stmt->bind_param("s", $surveyorID);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();

    echo json_encode(["count" => (int)$result['count']]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
