<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

$surveyorID = $_GET['surveyorID'] ?? '';
$uploadStatus = $_GET['uploadStatus'] ?? '0';

if (empty($surveyorID)) {
    http_response_code(400);
    echo json_encode(["error" => "Missing surveyorID parameter"]);
    exit;
}

if (!isset($pdo) && isset($conn)) {
    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
        exit;
    }

    try {
        $sql = "SELECT * FROM customer_assignment WHERE surveyorID = ?";
        $params = [$surveyorID];
        $types = "s";
        
        if ($uploadStatus !== null) {
            $sql .= " AND uploadStatus = ?";
            $params[] = $uploadStatus;
            $types .= "s";
        }

        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();
        $submissions = $result->fetch_all(MYSQLI_ASSOC);
        
        echo json_encode($submissions);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => "Database error: " . $e->getMessage()]);
    }
    
    $conn->close();
    exit;
}

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection not properly initialized"]);
    exit;
}

try {
    $sql = "SELECT * FROM customer_assignment WHERE surveyorID = ?";
    $params = [$surveyorID];
    
    if ($uploadStatus !== null) {
        $sql .= " AND uploadStatus = ?";
        $params[] = $uploadStatus;
    }

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $submissions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($submissions);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}