<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

include 'connect.php';

try {
    $role = $_GET['role'] ?? $_POST['role'] ?? null;
    $businessUnit = $_GET['businessUnit'] ?? $_POST['businessUnit'] ?? null;
    
    if (!$role) {
        throw new Exception("Role parameter is required");
    }
    
    if (strtolower($role) === 'admin' || strtolower($role) === 'mowasscosupervisor') {
        $query = "SELECT COUNT(*) as count 
                  FROM uploaded_survey_data 
                  WHERE propertyAccessibility = 'PTC'
                  AND potentialCustomerName IS NOT NULL 
                  AND potentialCustomerName <> ''";
        
        $stmt = $conn->prepare($query);
    } else {
        if (!$businessUnit) {
            throw new Exception("Business unit parameter is required for non-admin users");
        }
        
        $query = "SELECT COUNT(*) as count 
                  FROM uploaded_survey_data 
                  WHERE propertyAccessibility = 'PTC'
                  AND potentialCustomerName IS NOT NULL 
                  AND potentialCustomerName <> ''
                  AND businessUnit = ?";
        
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $businessUnit);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $countData = $result->fetch_assoc();
    
    echo json_encode([
        "success" => true,
        "count" => (int)$countData['count'],
        "role" => $role,
        "businessUnit" => $businessUnit
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "error" => "Server error: " . $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
}
?>