<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
include 'connect.php';

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$role = $_GET['role'] ?? '';
$businessUnit = $_GET['businessUnit'] ?? '';
$filterType = $_GET['filterType'] ?? 'POTENTIAL';

$sql = "SELECT propertyAccessibility, propertyImagePath, propertyType, propertyLatitude, 
        physicalAddress, propertyLongitude, businessUnit,
        potentialCustomerName, potentialCustomerPhoneNumber, surveyorID,
        potentialCustomerEmailAddress, potentialCustomerPhysicalAddress, 
        potentialCustomerLatitude, potentialCustomerLongitude
        FROM uploaded_survey_data
        WHERE ";

switch ($filterType) {
    case 'VCNPRM':
        $sql .= "propertyType = 'VCNPRM' AND propertyAccessibility IN ('ABT', 'DN', 'AL')";
        break;
    case 'VCNPLT':
        $sql .= "propertyType = 'VCNPLT' AND propertyAccessibility IN ('ABT', 'DN', 'AL')";
        break;
    case 'POTENTIAL':
    default:
        $sql .= "propertyAccessibility = 'PTC' AND potentialCustomerName IS NOT NULL AND potentialCustomerName <> ''";
        break;
}
if ($role === 'Admin' || $role === 'MowasscoSupervisor') {
} else if ($role === 'MowasscoTeam' && !empty($businessUnit)) {
    $sql .= " AND businessUnit = '" . $conn->real_escape_string($businessUnit) . "'";
} else {
    $sql .= " AND 1=0"; 
}

$result = $conn->query($sql);
$customers = array();

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $customers[] = $row;
    }
}

$conn->close();
header('Content-Type: application/json');
echo json_encode($customers);
?>