<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php"; // this should initialize $conn (MySQLi)

$surveyorID = $_GET['surveyorID'] ?? '';
$verificationStatus = $_GET['verificationStatus'] ?? null;

if (empty($surveyorID)) {
    http_response_code(400);
    echo json_encode(["error" => "Missing surveyorID parameter"]);
    exit;
}

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

try {
    // Base query
    $sql = "SELECT * 
            FROM uploaded_survey_data 
            WHERE surveyorID = ? 
              AND businessUnit = 'Island'";

    $params = [$surveyorID];
    $types  = "s";

    if ($verificationStatus !== null) {
        $sql .= " AND verificationStatus = ?";
        $params[] = (int)$verificationStatus;
        $types   .= "i";
    } else {
        $sql .= " AND verificationStatus IN (2,3)";
    }

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();

    $submissions = $result->fetch_all(MYSQLI_ASSOC);

    echo json_encode($submissions);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}

$conn->close();
