<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'connect.php';

$fromDate = $_GET['from'] ?? '';
$toDate = $_GET['to'] ?? '';

if (empty($fromDate) || empty($toDate)) {
    http_response_code(400);
    echo json_encode(['error' => 'Both from and to dates are required']);
    exit;
}

try {
    $stmt = $conn->prepare("CALL GetSurveysByDateRange(?, ?)");
    $stmt->bind_param("ss", $fromDate, $toDate);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    
    echo json_encode(['success' => true, 'data' => $data]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}