<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");

require_once 'connect.php';

$empID = isset($_GET['empID']) ? $_GET['empID'] : null;

if (!$empID) {
    http_response_code(400);
    echo json_encode(["error" => "Supervisor ID is required"]);
    exit;
}

try {
    $query = "SELECT COUNT(*) as count 
              FROM uploaded_survey_data s
              JOIN surveyor sv ON s.surveyorID = sv.surveyorID
              WHERE sv.empID = ? ";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $empID);
    $stmt->execute();
    $result = $stmt->get_result();
    $countData = $result->fetch_assoc();
    
    echo json_encode(["count" => (int)$countData['count']]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Server error: " . $e->getMessage()]);
}

$conn->close();
?>