<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include "connect.php";

try {

    $query = "
        SELECT ca.`accountNo`, ca.`name`, ca.`plotNo`, ca.`zone`, ca.`route`
        FROM customer_assignment ca
        WHERE ca.surveyorID IS NULL OR ca.surveyorID = ''
        LIMIT 3000
    ";
    $result = $conn->query($query);
    
    if (!$result) {
        throw new Exception("Query error: " . $conn->error);
    }

    $customers = [];
    while ($row = $result->fetch_assoc()) {
        $customers[] = [
            'accountNo' => $row['accountNo'],
            'name' => $row['name'],
            'plotNo' => $row['plotNo'],
            'zone' => $row['zone'],
            'route' => $row['route']
        ];
    }

    $zoneQuery = "SELECT DISTINCT `zone` FROM customer_assignment WHERE `zone` IS NOT NULL AND `zone` != '' ORDER BY `zone`";
    $zoneResult = $conn->query($zoneQuery);
    $zones = [];
    while ($row = $zoneResult->fetch_assoc()) {
        $zones[] = $row['zone'];
    }

    $routeQuery = "SELECT DISTINCT `route` FROM customer_assignment WHERE `route` IS NOT NULL AND `route` != '' ORDER BY `route`";
    $routeResult = $conn->query($routeQuery);
    $routes = [];
    while ($row = $routeResult->fetch_assoc()) {
        $routes[] = $row['route'];
    }

    $routesByZone = [];
    foreach ($customers as $customer) {
        $zone = $customer['zone'];
        $route = $customer['route'];
        
        if (!empty($zone) && !empty($route)) {
            if (!isset($routesByZone[$zone])) {
                $routesByZone[$zone] = [];
            }
            if (!in_array($route, $routesByZone[$zone])) {
                $routesByZone[$zone][] = $route;
            }
        }
    }

    foreach ($routesByZone as &$zoneRoutes) {
        sort($zoneRoutes);
    }

    echo json_encode([
        'customers' => $customers,
        'zones' => $zones,
        'routes' => $routes,
        'routesByZone' => $routesByZone
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
} finally {
    if (isset($conn)) {
        $conn->close();
    }
}