<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");

include 'connect.php';

$empID = isset($_GET['empID']) ? $_GET['empID'] : null;

if (!$empID) {
    http_response_code(400);
    echo json_encode(["error" => "Supervisor ID required"]);
    exit;
}

try {
    $updateQuery = "UPDATE uploaded_survey_data s
                   JOIN surveyor sv ON s.surveyorID = sv.surveyorID
                   SET s.verificationStatus = 0
                   WHERE sv.empID = ? 
                   AND s.verificationStatus IS NULL";
    $stmt = $conn->prepare($updateQuery);
    $stmt->bind_param("s", $empID);
    $stmt->execute();

    $countQuery = "SELECT 
                  SUM(CASE WHEN s.verificationStatus = 1 THEN 1 ELSE 0 END) as approved,
                  SUM(CASE WHEN s.verificationStatus = 0 THEN 1 ELSE 0 END) as pending,
                  SUM(CASE WHEN s.verificationStatus = 2 THEN 1 ELSE 0 END) as rejected
                  FROM uploaded_survey_data s
                  JOIN surveyor sv ON s.surveyorID = sv.surveyorID
                  WHERE sv.empID = ?";
    $stmt = $conn->prepare($countQuery);
    $stmt->bind_param("s", $empID);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    echo json_encode([
        'approved' => (int)$data['approved'],
        'pending' => (int)$data['pending'],
        'rejected' => (int)$data['rejected']
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Server error: " . $e->getMessage()]);
}

$conn->close();
