<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'connect.php';

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['accNos']) || !isset($data['newSurveyorID'])) {
    echo json_encode(["success" => false, "message" => "Missing accNo or newSurveyorID"]);
    exit;
}

$accNos = $data['accNos'];
$newSurveyorID = $data['newSurveyorID'];

if (!is_array($accNos) || empty($accNos)) {
    echo json_encode(["success" => false, "message" => "accNos must be a non-empty array"]);
    exit;
}

$placeholders = implode(',', array_fill(0, count($accNos), '?'));
$types = str_repeat('s', count($accNos));

$filterSql = "SELECT accountNumber FROM uploaded_survey_data WHERE accountNumber IN ($placeholders) AND verificationStatus = '2'";
$filterStmt = $conn->prepare($filterSql);
$filterStmt->bind_param($types, ...$accNos);
$filterStmt->execute();
$result = $filterStmt->get_result();

$filteredAccNos = [];
while ($row = $result->fetch_assoc()) {
    $filteredAccNos[] = $row['accountNumber'];
}
$filterStmt->close();

if (empty($filteredAccNos)) {
    echo json_encode(["success" => false, "message" => "No customers found"]);
    $conn->close();
    exit;
}

$placeholders = implode(',', array_fill(0, count($filteredAccNos), '?'));
$types = str_repeat('s', count($filteredAccNos));

$clearSql = "UPDATE uploaded_survey_data SET surveyorID = NULL WHERE accountNumber IN ($placeholders)";
$clearStmt = $conn->prepare($clearSql);
$clearStmt->bind_param($types, ...$filteredAccNos);
$clearStmt->execute();
$clearStmt->close();

$assignSql = "UPDATE uploaded_survey_data SET surveyorID = ? WHERE accountNumber IN ($placeholders)";
$assignStmt = $conn->prepare($assignSql);

$params = array_merge([$newSurveyorID], $filteredAccNos);
$assignStmt->bind_param("s" . $types, ...$params);

if ($assignStmt->execute()) {
    echo json_encode(["success" => true, "message" => "Customers reassigned successfully"]);
} else {
    echo json_encode(["success" => false, "message" => "Database error: " . $assignStmt->error]);
}

$assignStmt->close();
$conn->close();
?>