<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

require_once 'connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];
$response = [];
$statusCode = 200;

try {
    switch ($method) {
        case 'GET':
        
            $query = "SELECT DISTINCT empID, businessUnit FROM users 
                      WHERE businessUnit IS NOT NULL 
                      AND businessUnit != '' 
                      AND role = 'MowasscoTeam'
                      ORDER BY businessUnit ASC";
            $result = $conn->query($query);
            
            if ($result->num_rows > 0) {
                $businessUnits = [];
                while ($row = $result->fetch_assoc()) {
                    $businessUnits[] = [
                        "epmID" => $row['empID'],
                        "name" => $row['businessUnit']
                    ];
                }
                $response = [
                    "success" => true,
                    "businessUnits" => $businessUnits,
                    "timestamp" => date('Y-m-d H:i:s')
                ];
            } else {
                $statusCode = 404;
                $response = [
                    "success" => false,
                    "message" => "No business units found.",
                    "timestamp" => date('Y-m-d H:i:s')
                ];
            }
            break;

      case 'POST':
    $data = json_decode(file_get_contents("php://input"));

    if ((isset($data->accountNumber) && $data->accountNumber !== '') || isset($data->customerId)) {
        if (!isset($data->businessUnit)) {
            $statusCode = 400;
            $response = [
                "success" => false,
                "message" => "Business Unit is required.",
                "timestamp" => date('Y-m-d H:i:s')
            ];
            break;
        }

        $businessUnit = $conn->real_escape_string($data->businessUnit);
        
        if (!empty($data->accountNumber)) {
            $accountNumber = $conn->real_escape_string($data->accountNumber);
            $query = "UPDATE uploaded_survey_data SET businessUnit = ? WHERE accountNumber = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ss", $businessUnit, $accountNumber);
        } elseif (!empty($data->customerId)) {
            $customerId = intval($data->customerId);
            $query = "UPDATE uploaded_survey_data SET businessUnit = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("si", $businessUnit, $customerId);
        }

        if ($stmt->execute()) {
            $response = [
                "success" => true,
                "message" => "Business Unit updated successfully.",
                "updatedRecord" => [
                    "accountNumber" => $data->accountNumber ?? null,
                    "customerId" => $data->customerId ?? null,
                    "businessUnit" => $businessUnit
                ],
                "timestamp" => date('Y-m-d H:i:s')
            ];
        } else {
            $statusCode = 500;
            $response = [
                "success" => false,
                "message" => "Database error: " . $stmt->error,
                "timestamp" => date('Y-m-d H:i:s')
            ];
        }
        $stmt->close();
    } else {
        $statusCode = 400;
        $response = [
            "success" => false,
            "message" => "Invalid request data. Either accountNumber or customerId must be provided, and businessUnit is required.",
            "timestamp" => date('Y-m-d H:i:s')
        ];
    }
    break;

    }
} catch (Exception $e) {
    $statusCode = 500;
    $response = [
        "success" => false,
        "message" => "Server error: " . $e->getMessage(),
        "timestamp" => date('Y-m-d H:i:s')
    ];
}

http_response_code($statusCode);
echo json_encode($response);

$conn->close();
?>