<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
include "connect.php";

header('Content-Type: application/json');

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

$rawInput = file_get_contents("php://input");
$postData = json_decode($rawInput, true);

if (!is_array($postData)) {
    die(json_encode(["status" => "error", "message" => "Invalid JSON format"]));
}

if (!isset($postData['tableid'],$postData['tabledesc'], $postData['lineid'], $postData['description'], $postData['linkcomment'], $postData['controller'], $postData['lineOrder'], $postData['visibility'])) {
    die(json_encode(["status" => "error", "message" => "Missing required fields"]));
}
// $hashedPassword = password_hash($postData['password'], PASSWORD_BCRYPT);

$stmt = $conn->prepare("INSERT INTO lookupdata (tableid,tabledesc, lineid, description, linkcomment, controller, lineOrder,visibility) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bind_param("sssssiss",
    $postData['tableid'],
    $postData['tabledesc'], 
    $postData['lineid'],  
    $postData['description'], 
    $postData['linkcomment'],
    $postData['controller'],
    $postData['lineOrder'],
    $postData['visibility']
    // $hashedPassword  
);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "LookUp entry added successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Error: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
