<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
header("Content-Type: application/json");

$logFile = 'anomaly_logs.log';
function logMessage($message, $logFile) {
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message" . PHP_EOL;
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

include 'connect.php';

$role = isset($_GET['role']) ? $_GET['role'] : '';
$businessUnit = isset($_GET['businessUnit']) ? $_GET['businessUnit'] : '';

logMessage("Starting anomaly detection process for role=$role, businessUnit=$businessUnit", $logFile);

$response = [];

try {

    logMessage("Executing DetectAndLogAnomalies stored procedure", $logFile);
    if (!$conn->query("CALL DetectAndLogAnomalies()")) {
        throw new Exception("Stored procedure failed: " . $conn->error);
    }
    logMessage("Stored procedure executed successfully", $logFile);

$whereClause = "da.verified = false";
if ($role === "MowasscoTeam" && !empty($businessUnit)) {
    $escapedBU = $conn->real_escape_string($businessUnit);
    $whereClause .= " AND usd.businessUnit = '" . $escapedBU . "' 
                     AND usd.verificationStatus = '1'";
}

$latestQuery = "
    SELECT da.* 
    FROM data_anomalies da
    INNER JOIN (
        SELECT accountNumber, MAX(id) as maxId
        FROM data_anomalies
        WHERE verified = false
        GROUP BY accountNumber
    ) latest ON da.id = latest.maxId
    INNER JOIN uploaded_survey_data usd 
        ON da.accountNumber = usd.accountNumber
    WHERE $whereClause
    ORDER BY da.anomalyDate DESC
";


    logMessage("Executing latest anomalies query: " . str_replace(["\n", "\r", "\t"], " ", $latestQuery), $logFile);
    $latestResult = $conn->query($latestQuery);
    if ($latestResult === false) {
        throw new Exception("Latest anomalies query failed: " . $conn->error);
    }

$allQuery = "
    SELECT da.* 
    FROM data_anomalies da
    INNER JOIN uploaded_survey_data usd 
        ON da.accountNumber = usd.accountNumber
    WHERE $whereClause
    ORDER BY da.accountNumber, da.anomalyDate DESC
";
  
    logMessage("Executing all anomalies query: " . str_replace(["\n", "\r", "\t"], " ", $allQuery), $logFile);
    $allResult = $conn->query($allQuery);
    if ($allResult === false) {
        throw new Exception("All anomalies query failed: " . $conn->error);
    }

    $latest = [];
    $grouped = [];
    $processedAccounts = [];

    logMessage("Latest anomalies rows: " . $latestResult->num_rows, $logFile);
    while ($row = $latestResult->fetch_assoc()) {
        if ($row && isset($row['accountNumber'])) {
            if (!in_array($row['accountNumber'], $processedAccounts)) {
                $latest[] = $row;
                $processedAccounts[] = $row['accountNumber'];
            }
        }
    }

    logMessage("All anomalies rows: " . $allResult->num_rows, $logFile);
    while ($row = $allResult->fetch_assoc()) {
        if ($row && isset($row['accountNumber'])) {
            $grouped[$row['accountNumber']][] = $row;
        }
    }

    $response['success'] = true;
    $response['latest'] = $latest;
    $response['grouped'] = $grouped;

} catch (Exception $e) {
    $response['success'] = false;
    $response['error'] = $e->getMessage();
    http_response_code(500);
    logMessage("Error: " . $e->getMessage(), $logFile);
}

echo json_encode($response);
$conn->close();