<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
include 'connect.php';

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$filterType = $_GET['filterType'] ?? 'POTENTIAL';

$sql = "SELECT propertyAccessibility,physicalAddress, propertyImagePath, propertyType,propertyLatitude, propertyLongitude, businessUnit,
        potentialCustomerName, potentialCustomerPhoneNumber, surveyorID,
        potentialCustomerEmailAddress, potentialCustomerPhysicalAddress, 
        potentialCustomerLatitude, potentialCustomerLongitude
        FROM uploaded_survey_data
        WHERE ";

switch ($filterType) {
    case 'VCNPRM':
        $sql .= "propertyType = 'VCNPRM' AND propertyAccessibility IN ('ABT', 'DN', 'AL')";
        break;
    case 'VCNPLT':
        $sql .= "propertyType = 'VCNPLT' AND propertyAccessibility IN ('ABT', 'DN', 'AL')";
        break;
    case 'POTENTIAL':
    default:
        $sql .= "propertyAccessibility = 'PTC' AND potentialCustomerName IS NOT NULL AND potentialCustomerName <> ''";
        break;
}

$result = $conn->query($sql);
$customers = array();

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $customers[] = $row;
    }
}

$conn->close();
header('Content-Type: application/json');
echo json_encode($customers);