<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "connect.php";

if (!isset($pdo) && isset($conn)) {

    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
        exit;
    }
    
    $surveyorID = $_GET['surveyorID'] ?? '';

    if (empty($surveyorID)) {
        http_response_code(400);
        echo json_encode(["error" => "Missing surveyorID parameter"]);
        exit;
    }

    try {
        $stmt = $conn->prepare("SELECT * FROM uploaded_survey_data WHERE surveyorID = ? LIMIT 1000");
        $stmt->bind_param("s", $surveyorID);
        $stmt->execute();
        $result = $stmt->get_result();
        $submissions = $result->fetch_all(MYSQLI_ASSOC);
        echo json_encode($submissions);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => "Database error: " . $e->getMessage()]);
    }
    
    $conn->close();
    exit;
}

if (!isset($pdo)) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection not properly initialized"]);
    exit;
}

$surveyorID = $_GET['surveyorID'] ?? '';

if (empty($surveyorID)) {
    http_response_code(400);
    echo json_encode(["error" => "Missing surveyorID parameter"]);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT * FROM uploaded_survey_data WHERE surveyorID = ?");
    $stmt->execute([$surveyorID]);
    $submissions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($submissions);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}