<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

include 'connect.php';
$imageDir = __DIR__ . '/surveyCapturedImages/capturedImages/';
$allowedExtensions = ['jpg', 'jpeg', 'png', 'gif'];
$images = [];

if (file_exists($imageDir)) {
    $files = scandir($imageDir);
    foreach ($files as $file) {
        if ($file === '.' || $file === '..') continue;
        $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        if (in_array($ext, $allowedExtensions)) {
            $images[] = $file;
        }
    }
}

echo json_encode(['images' => $images]);
?>