<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

include 'connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$data = json_decode(file_get_contents("php://input"), true);
$empID = $data['empID'] ?? '';
$password = $data['password'] ?? '';

$response = ['success' => false, 'message' => ''];

if (empty($empID) || empty($password)) {
    $response['message'] = "Missing credentials";
    echo json_encode($response);
    exit();
}

$stmt = $conn->prepare("SELECT * FROM users WHERE empID = ?");
$stmt->bind_param("s", $empID);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();

    if ($user['password'] === $password) { 
        unset($user['password']);
        $response['success'] = true;
        $response['user'] = $user;
    } else {
        $response['message'] = "Invalid credentials";
    }
} else {
    $response['message'] = "User not found";
}

$stmt->close();
$conn->close();

echo json_encode($response);
