<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

include "connect.php";

if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed: " . $conn->connect_error]));
}

if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    http_response_code(405);
    die(json_encode(["status" => "error", "message" => "Only PUT method is allowed"]));
}

$rawInput = file_get_contents("php://input");
$postData = json_decode($rawInput, true);

if (!is_array($postData)) {
    http_response_code(400);
    die(json_encode(["status" => "error", "message" => "Invalid JSON format"]));
}

if (!isset($postData['tableid'], $postData['lineid'])) {
    http_response_code(400);
    die(json_encode(["status" => "error", "message" => "Missing required fields: tableid and lineid"]));
}

$stmt = $conn->prepare("UPDATE lookupdata SET 
    tabledesc = ?, 
    description = ?, 
    linkcomment = ?, 
    controller = ?,
    lineOrder = ?, 
    visibility = ? 
WHERE tableid = ? AND lineid = ?");

$stmt->bind_param("sssisiss",
    $postData['tabledesc'], 
    $postData['description'], 
    $postData['linkcomment'],
    $postData['controller'],
    $postData['lineOrder'],
    $postData['visibility'],  
    $postData['tableid'],
    $postData['lineid']
);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode([
            "status" => "success", 
            "message" => "LookUp updated successfully",
            "affected_rows" => $stmt->affected_rows,
            "composite_key" => [
                "tableid" => $postData['tableid'],
                "lineid" => $postData['lineid']
            ]
        ]);
    } else {
        $checkStmt = $conn->prepare("SELECT 1 FROM lookupdata WHERE tableid = ? AND lineid = ?");
        $checkStmt->bind_param("ss", $postData['tableid'], $postData['lineid']);
        $checkStmt->execute();
        $exists = $checkStmt->get_result()->num_rows > 0;
        $checkStmt->close();
        
        $message = $exists ? 
            "No changes were made (data identical)" : 
            "No record found with tableid: {$postData['tableid']} and lineid: {$postData['lineid']}";
        
        http_response_code($exists ? 200 : 404);
        echo json_encode([
            "status" => $exists ? "success" : "error",
            "message" => $message
        ]);
    }
} else {
    http_response_code(500);
    echo json_encode([
        "status" => "error", 
        "message" => "Database error: " . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>